/***********************************
 *								   *
 *	Scatter Search C code		   *
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *
 *								   *
 ***********************************/

#include "SS3c.h"

void SSCreate_RefSets(SS *pb)
{
	int b1,i,j,a,*p_order,*min_dist;

	/* Order solutions in P */
	p_order = SSOrder_i(pb->p->ObjVal,pb->p->PSize,1);

	/* Add the b1 best solutions in P to RefSet1 */
	b1 = pb->rs1->b;
	for(i=1;i<=b1;i++)
	{
		for(j=1;j<=pb->nvar;j++)
			pb->rs1->sol[i][j] = pb->p->sol[p_order[i]][j];
		pb->rs1->ObjVal[i] = pb->p->ObjVal[p_order[i]];
		pb->rs1->iter[i] = 1;
		pb->rs1->order[i] = i;
		pb->rs1->g[i]=0;
	}

	/* Add the b3 best solutions in P, not in RefSet1, to RefSet3 */
	for(i=1;i<=pb->rs3->b;i++)
	{
		for(j=1;j<=pb->nvar;j++)
			pb->rs3->sol[i][j] = pb->p->sol[p_order[b1+i]][j];
		pb->rs3->ObjVal[i] = pb->p->ObjVal[p_order[b1+i]];
		pb->rs3->iter[i] = 1;
		pb->rs3->order[i] = i;
		pb->rs3->g[i]=0;
	}

	/* Compute minimum distances from P to RefSet1 */
	min_dist = SSInt_array(pb->p->PSize);	
	for(i=1;i<=pb->p->PSize;i++)
		min_dist[i]= SSDist_RefSet(pb,b1,pb->p->sol[i]);

	/* Add the diverse b2 solutions to RefSet2 */
	for(i=1;i<=pb->rs2->b;i++)
	{
		a=SSMax_dist_index(pb,min_dist);

		for(j=1;j<=pb->nvar;j++)
			pb->rs2->sol[i][j] = pb->p->sol[a][j];
		pb->rs2->ObjVal[i] = pb->p->ObjVal[a];
		pb->rs2->DivVal[i] = min_dist[a];
		pb->rs2->iter[i] = 1;
		pb->rs2->order[i] = i;

		min_dist[a]=0;
	}

	pb->rs1->NewSolutions = 1;
	pb->rs2->NewSolutions = 1;
	pb->CurrentIter      = 1;

	free(p_order+1);free(min_dist+1);
}

void SSRebuild_RefSet2(SS *pb)
{	
	int *min_dist;
	int b1,i,j,a;

	b1 = pb->rs1->b;

	/* Create a new set P */
	SSCreate_P(pb);

	/* Compute minimum distances from P to RefSet1 */
	min_dist = SSInt_array(pb->p->PSize);	
	for(i=1;i<=pb->p->PSize;i++)
		min_dist[i]= SSDist_RefSet(pb,b1,pb->p->sol[i]);
	
	/* Add the diverse b2 solutions to RefSet2 */
	for(i=1;i<=pb->rs2->b;i++)
	{
		a=SSMax_dist_index(pb,min_dist);
		for(j=1;j<=pb->nvar;j++)
			pb->rs2->sol[i][j] = pb->p->sol[a][j];
		pb->rs2->ObjVal[i] = pb->p->ObjVal[a];
		pb->rs2->DivVal[i] = min_dist[a];
		pb->rs2->iter[i] = pb->CurrentIter;
		pb->rs2->order[i] = i;

		min_dist[a]=0;
	}

	pb->rs2->NewSolutions = 1;
	free(min_dist+1);
}

void SSUpdate_RefSets(SS *pb)
{
	int a,value;

	pb->rs1->NewSolutions=0;
	pb->rs2->NewSolutions=0;

	SSCombine_RefSets(pb);
	pb->CurrentIter++;

	for(a=1;a<=pb->pool_size;a++)
	{
		value=pb->pool_value[a];
		SSImprove_solution(pb,pb->pool[a],&value);
		SSTryAdd_RefSets(pb,pb->pool[a],value);
	}

	pb->pool_size=0;
}

void SSCombine_RefSets(SS *pb)
{
	int i,j,s;
	int *newsol,*rs_order;

	newsol = SSInt_array(pb->nvar);

	/* Combine elements in RefSet1 */
	for(i=1;i<pb->rs1->b;i++)
	for(j=i+1;j<=pb->rs1->b;j++)
	{
		/* Combine solutions not previously combined */
		if(pb->rs1->iter[i] == pb->CurrentIter ||
		   pb->rs1->iter[j] == pb->CurrentIter)
		{
			SSCombine(pb,pb->rs1->sol[i],pb->rs1->sol[j],pb->rs1->ObjVal[i],pb->rs1->ObjVal[j],newsol);
			pb->pool_value[++pb->pool_size]=sol_value(pb,newsol);
			for(s=1;s<=pb->nvar;s++)
				pb->pool[pb->pool_size][s]=newsol[s];

			if(pb->pool_value[pb->pool_size]>pb->rs1->g[i]) pb->rs1->g[i]=pb->pool_value[pb->pool_size];
			if(pb->pool_value[pb->pool_size]>pb->rs1->g[j]) pb->rs1->g[j]=pb->pool_value[pb->pool_size];
		}
	}

	/* Combine elements in RefSet2 */
	for(i=1;i<pb->rs2->b;i++)
	for(j=i+1;j<=pb->rs2->b;j++)
	{
		/* Combine solutions not previously combined */
		if(pb->rs2->iter[i] == pb->CurrentIter ||
		   pb->rs2->iter[j] == pb->CurrentIter)
		{
			SSCombine(pb,pb->rs2->sol[i],pb->rs2->sol[j],pb->rs2->ObjVal[i],pb->rs2->ObjVal[j],newsol);
			pb->pool_value[++pb->pool_size]=sol_value(pb,newsol);
			for(s=1;s<=pb->nvar;s++)
				pb->pool[pb->pool_size][s]=newsol[s];
		}
	}

	/* Combine elements in RefSet1 with elements in RefSet2 */
	for(i=1;i<pb->rs1->b;i++)
	for(j=1;j<=pb->rs2->b;j++)
	{
		/* Combine solutions not previously combined */
		if(pb->rs1->iter[i] == pb->CurrentIter ||
		   pb->rs2->iter[j] == pb->CurrentIter)
		{
			SSCombine(pb,pb->rs1->sol[i],pb->rs2->sol[j],pb->rs1->ObjVal[i],pb->rs2->ObjVal[j],newsol);
			pb->pool_value[++pb->pool_size]=sol_value(pb,newsol);
			for(s=1;s<=pb->nvar;s++)
				pb->pool[pb->pool_size][s]=newsol[s];
			
			if(pb->pool_value[pb->pool_size]>pb->rs1->g[i]) pb->rs1->g[i]=pb->pool_value[pb->pool_size];
		}
	}

	/* Combine elements in RefSet3 */
	for(i=1;i<pb->rs3->b;i++)
	for(j=i+1;j<=pb->rs3->b;j++)
	{
		/* Combine solutions not previously combined */
		if(pb->rs3->iter[i] == pb->CurrentIter ||
		   pb->rs3->iter[j] == pb->CurrentIter)
		{
			SSCombine(pb,pb->rs3->sol[i],pb->rs3->sol[j],pb->rs3->ObjVal[i],pb->rs3->ObjVal[j],newsol);
			pb->pool_value[++pb->pool_size]=sol_value(pb,newsol);
			for(s=1;s<=pb->nvar;s++)
				pb->pool[pb->pool_size][s]=newsol[s];

			if(pb->pool_value[pb->pool_size]>pb->rs3->g[i]) pb->rs3->g[i]=pb->pool_value[pb->pool_size];
			if(pb->pool_value[pb->pool_size]>pb->rs3->g[j]) pb->rs3->g[j]=pb->pool_value[pb->pool_size];
		}
	}


	/* Combine elements in RefSet1 with elements in RefSet3 */
	for(i=1;i<pb->rs1->b;i++)
	for(j=1;j<=pb->rs3->b;j++)
	{
		/* Combine solutions not previously combined */
		if(pb->rs1->iter[i] == pb->CurrentIter ||
		   pb->rs3->iter[j] == pb->CurrentIter)
		{
			SSCombine(pb,pb->rs1->sol[i],pb->rs3->sol[j],pb->rs1->ObjVal[i],pb->rs3->ObjVal[j],newsol);
			pb->pool_value[++pb->pool_size]=sol_value(pb,newsol);
			for(s=1;s<=pb->nvar;s++)
				pb->pool[pb->pool_size][s]=newsol[s];
			
			if(pb->pool_value[pb->pool_size]>pb->rs1->g[i]) pb->rs1->g[i]=pb->pool_value[pb->pool_size];
			if(pb->pool_value[pb->pool_size]>pb->rs3->g[j]) pb->rs3->g[j]=pb->pool_value[pb->pool_size];
		}
	}

	/* Combine elements in RefSet2 with elements in RefSet3 */
	for(i=1;i<pb->rs2->b;i++)
	for(j=1;j<=pb->rs3->b;j++)
	{
		/* Combine solutions not previously combined */
		if(pb->rs2->iter[i] == pb->CurrentIter ||
		   pb->rs3->iter[j] == pb->CurrentIter)
		{
			SSCombine(pb,pb->rs2->sol[i],pb->rs3->sol[j],pb->rs2->ObjVal[i],pb->rs3->ObjVal[j],newsol);
			pb->pool_value[++pb->pool_size]=sol_value(pb,newsol);
			for(s=1;s<=pb->nvar;s++)
				pb->pool[pb->pool_size][s]=newsol[s];
			
			if(pb->pool_value[pb->pool_size]>pb->rs3->g[j]) pb->rs3->g[j]=pb->pool_value[pb->pool_size];
		}
	}

	/* Compute order in RefSet3 */
	rs_order = SSOrder_i(pb->rs3->g,pb->rs3->b,1);
	for(i=1;i<=pb->rs3->b;i++)
		pb->rs3->order[i]=rs_order[i];
	free(rs_order+1);


	free(newsol+1);
}

void SSTryAdd_RefSets(SS *pb,int sol[],int value)
{
	int i,j,k,dist,g_value,changedist,*rs_order;
	int worst_index1,worst_index2,worst_index3;

	worst_index1 = pb->rs1->order[pb->rs1->b];
	worst_index2 = pb->rs2->order[pb->rs2->b];
	worst_index3 = pb->rs3->order[pb->rs3->b];
	dist		 = SSDist_RefSet(pb,pb->rs1->b,sol);

	/* Try to add to RefSet1 according to its Obj Value */
	if(!SSIsInRefSet(pb,pb->rs1,sol) && value>pb->rs1->ObjVal[worst_index1])
	{
		/* Try to add the solution removed from RefSet1 to RefSet3 */
		if(pb->rs1->g[worst_index1] > pb->rs3->g[worst_index3])
		{
			/* Find position i for sol. insertion */
			g_value=pb->rs1->g[worst_index1]; 
			i=pb->rs3->b;
			while(i>=1 && g_value>pb->rs3->g[pb->rs3->order[i]])
				i--;
			i++;

			SSInsertInRefSet(pb,pb->rs3,sol,worst_index3,i,value,0);
			pb->rs3->g[worst_index3]=g_value;
		}

		/* Find position i in RefSet1 for sol. insertion */
		i=pb->rs1->b;
		while(i>=1 && value>pb->rs1->ObjVal[pb->rs1->order[i]])
			i--;
		i++;

		SSInsertInRefSet(pb,pb->rs1,sol,worst_index1,i,value,0);

		/*Update distances and order in RefSet2 */
		changedist=0;
		for(k=1;k<=pb->rs2->b;k++)
		{
			dist=0;
			for(j=1;j<=pb->nvar;j++)
				dist += abs(sol[j]-pb->rs2->sol[k][j]);
			if(pb->rs2->DivVal[k]> dist)
			{
				changedist=1;
				pb->rs2->DivVal[k]=dist;
			}
		}
		if(changedist)
		{
			rs_order = SSOrder_i(pb->rs2->DivVal,pb->rs2->b,1);
			for(k=1;k<=pb->rs3->b;k++)
				pb->rs2->order[k]=rs_order[k];
			free(rs_order+1);
		}
	}

	/* Try to add to RefSet2 according to its Diversity Value */
	else if(!SSIsInRefSet(pb,pb->rs2,sol) && dist>pb->rs2->DivVal[worst_index2])
	{
		/* Find position i for sol. insertion */
		i=pb->rs2->b;
		while(i>=1 && dist>pb->rs2->DivVal[pb->rs2->order[i]])
			i--;
		i++;

		SSInsertInRefSet(pb,pb->rs2,sol,worst_index2,i,value,dist);
	}
}

void SSInsertInRefSet(SS *pb,REFSET *rs,int sol[],int worst_index,int new_index,int value,int dist)
{
	int j;

	/* Replace solution */
	for(j=1;j<=pb->nvar;j++)
		rs->sol[worst_index][j]=sol[j];
	rs->ObjVal[worst_index]=value;
	rs->DivVal[worst_index]=dist;
	rs->iter[worst_index]=pb->CurrentIter;

	/* Update ReSet order */
	for(j=rs->b;j>new_index;j--)
		rs->order[j]=rs->order[j-1];
	rs->order[new_index]=worst_index;

	rs->NewSolutions=1;
}

void SSCombine(SS *pb,int sol1[],int sol2[],int value1,int value2,int newsol[])
{
	int i,a;
	int i1=1;		/* Index in sol1 of its incipient element */
	int i2=1;		/* Index in sol2 of its incipient element */
	int v1,v2;		/* Votes of sol1[i1] and sol2[i2] respect.*/
	int *assign;	/* Assigned elements					  */

	assign = SSInt_array(pb->nvar);
	for(i=1;i<=pb->nvar;i++)
	{
		if(i1>pb->nvar) a=sol2[i2];
		else if (i2>pb->nvar) a=sol1[i1];
		else
		{
			v1 = 1 + i - i1;
			v2 = 1 + i - i2;

			if(v1>v2)				a=sol1[i1];
			else if(v2>v1)			a=sol2[i2];
			else if(value1>value2)	a=sol1[i1];
			else					a=sol2[i2];
		}
		assign[a]=1;
		newsol[i]=a;

		while(i1<=pb->nvar && assign[sol1[i1]]) i1++;
		while(i2<=pb->nvar && assign[sol2[i2]]) i2++;
	}
	free(assign+1);
}

void SSPrint_RefSets(SS *pb)
{
	FILE *pf;
	int i,j;

	pf=fopen("RefSet3.txt","w");
	if(!pf) SSAbort("File opening failure");

	for(i=1;i<=pb->rs1->b;i++)
	{
		fprintf(pf,"\n%2d ",i);
		fprintf(pf,"  %d    ",pb->rs1->ObjVal[pb->rs1->order[i]]);
		for(j=1;j<=pb->nvar;j++)
			fprintf(pf," %d",pb->rs1->sol[pb->rs1->order[i]][j]);
	}

	for(i=1;i<=pb->rs2->b;i++)
	{
		fprintf(pf,"\n%2d ",i);
		fprintf(pf,"  %d    ",pb->rs2->ObjVal[pb->rs2->order[i]]);
		for(j=1;j<=pb->nvar;j++)
			fprintf(pf," %d",pb->rs2->sol[pb->rs2->order[i]][j]);
	}
	fclose(pf);
}



